/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspIoBus;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;

public class FspIoSlotVpd {
    private UnsignedInt32 mDrcIndex;
    private String mType;
    private String mModel;
    private String mSerial;
    private static final String DRC_INDEX = "DRC_INDEX";
    private static final String TYPE = "TYPE";
    private static final String MODEL = "MODEL";
    private static final String SERIAL_NUMBER = "SERIAL_NUMBER";
    private static final String IO_SLOT_VPD_LIST = "IO_SLOT_VPD_LIST";
    private static final String GET_IO_SLOT_VPD = "GET_IO_SLOT_VPD";

    static FspIoSlotVpd[] getIoSlotsVpdInfo(FSPCmdMgr fSPCmdMgr, FspIoBus fspIoBus) throws PIHscServerException, PIHscCmdMgrException {
        int n = fspIoBus.getNumberOfSlots().intValue();
        FspIoSlotVpd[] fspIoSlotVpdArray = null;
        fspIoSlotVpdArray = FspIoSlotVpd.getIoSlotsVpdInfoCmd(fSPCmdMgr, fspIoBus, fspIoBus.getNumberOfSlots(), new UnsignedInt32(0L));
        if (fspIoSlotVpdArray.length == n || fspIoSlotVpdArray.length <= 10) {
            return fspIoSlotVpdArray;
        }
        int n2 = 0;
        FspIoSlotVpd[] fspIoSlotVpdArray2 = fspIoSlotVpdArray;
        fspIoSlotVpdArray = new FspIoSlotVpd[n];
        System.arraycopy(fspIoSlotVpdArray2, 0, fspIoSlotVpdArray, n2, fspIoSlotVpdArray2.length);
        n2 += fspIoSlotVpdArray2.length;
        while (n2 < n) {
            UnsignedInt32 unsignedInt32 = fspIoSlotVpdArray2[fspIoSlotVpdArray2.length - 1].mDrcIndex;
            fspIoSlotVpdArray2 = FspIoSlotVpd.getIoSlotsVpdInfoCmd(fSPCmdMgr, fspIoBus, fspIoBus.getNumberOfSlots(), unsignedInt32);
            if (fspIoSlotVpdArray2.length == 0) break;
            System.arraycopy(fspIoSlotVpdArray2, 0, fspIoSlotVpdArray, n2, fspIoSlotVpdArray2.length);
            n2 += fspIoSlotVpdArray2.length;
        }
        if (n2 < n) {
            fspIoSlotVpdArray2 = fspIoSlotVpdArray;
            fspIoSlotVpdArray = new FspIoSlotVpd[n2];
            System.arraycopy(fspIoSlotVpdArray2, 0, fspIoSlotVpdArray, 0, n2);
        }
        return fspIoSlotVpdArray;
    }

    static FspIoSlotVpd[] getIoSlotsVpdInfoCmd(FSPCmdMgr fSPCmdMgr, FspIoBus fspIoBus, UnsignedInt16 unsignedInt16, UnsignedInt32 unsignedInt32) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        FspIoSlotVpd[] fspIoSlotVpdArray = null;
        hashtable = fSPCmdMgr.doPhypCommand(GET_IO_SLOT_VPD, new String[]{fspIoBus.getBusId().toString(), unsignedInt16.toString(), unsignedInt32.toString()}, unsignedInt32);
        System.out.println("getIoSlotsVpdInfo --> response = " + hashtable);
        Object[] objectArray = (Object[])hashtable.get(IO_SLOT_VPD_LIST);
        fspIoSlotVpdArray = new FspIoSlotVpd[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            fspIoSlotVpdArray[i] = new FspIoSlotVpd();
            Hashtable hashtable2 = (Hashtable)objectArray[i];
            fspIoSlotVpdArray[i].mDrcIndex = (UnsignedInt32)hashtable2.get(DRC_INDEX);
            fspIoSlotVpdArray[i].mType = ((String)hashtable2.get(TYPE)).trim();
            fspIoSlotVpdArray[i].mModel = ((String)hashtable2.get(MODEL)).trim();
            fspIoSlotVpdArray[i].mSerial = ((String)hashtable2.get(SERIAL_NUMBER)).trim();
        }
        return fspIoSlotVpdArray;
    }

    public UnsignedInt32 getDrcIndex() {
        return this.mDrcIndex;
    }

    public String getType() {
        return this.mType;
    }

    public String getModel() {
        return this.mModel;
    }

    public String getSerial() {
        return this.mSerial;
    }

    public String toString() {
        String string = "drcIndex=";
        String string2 = "type=";
        String string3 = "modelStr";
        String string4 = "serial=";
        if (this.mDrcIndex != null) {
            string = string + this.mDrcIndex.toString();
        }
        if (this.mType != null) {
            string2 = string2 + this.mType.toString();
        }
        if (this.mModel != null) {
            string3 = string3 + this.mModel.toString();
        }
        if (this.mSerial != null) {
            string4 = string4 + this.mSerial.toString();
        }
        return string + "; " + string2 + "; " + string3 + "; " + string4;
    }
}

